/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveEntityMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final String entityName;

    public RemoveEntityMessage(PacketBuffer buf) {
        this.from = buf.func_179259_c();
        this.to = buf.func_179259_c();
        this.entityName = buf.func_150789_c(Short.MAX_VALUE);
    }

    public RemoveEntityMessage(@NotNull BlockPos pos1, @NotNull BlockPos pos2, @NotNull String entityName) {
        this.from = pos1;
        this.to = pos2;
        this.entityName = entityName;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_179255_a(this.from);
        buf.func_179255_a(this.to);
        buf.func_180714_a(this.entityName);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().func_184812_l_()) {
            return;
        }
        ServerWorld world = ctxIn.getSender().func_71121_q();
        ChangeStorage storage = new ChangeStorage((PlayerEntity)ctxIn.getSender());
        for (int x = Math.min(this.from.func_177958_n(), this.to.func_177958_n()); x <= Math.max(this.from.func_177958_n(), this.to.func_177958_n()); ++x) {
            for (int y = Math.min(this.from.func_177956_o(), this.to.func_177956_o()); y <= Math.max(this.from.func_177956_o(), this.to.func_177956_o()); ++y) {
                for (int z = Math.min(this.from.func_177952_p(), this.to.func_177952_p()); z <= Math.max(this.from.func_177952_p(), this.to.func_177952_p()); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    List list = world.func_217357_a(Entity.class, new AxisAlignedBB(here));
                    storage.addEntities(list);
                    for (Entity entity : list) {
                        if (!entity.func_200200_C_().getString().equals(this.entityName)) continue;
                        entity.func_70106_y();
                    }
                }
            }
        }
        Manager.addToUndoCache(storage);
    }
}

